<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hadiah extends Model
{
    use HasFactory;
    protected $fillable = [
        'kd_hadiah',
        'nm_hadiah',
        'stok',
        'poin',
        'gambar',
        'keterangan',
        'link_hadiah',
    ];

    public function scopePencarian(Builder $query): void
    {
        $kur = request('cari') - 50;
        $query->where('kd_hadiah', 'like', '%' . request('cari') . '%')
            ->orwhere('nm_hadiah', 'like', '%' . request('cari') . '%')
            ->orwhereBetween('poin', [$kur, request('cari')])
            ->orwhere('poin', 'like', '%' . request('cari') . '%');
    }
}
